<?php

namespace Database\Seeders;

use App\Models\TemplateLanguage;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {

    $languages = [
        ['country' => 'Afrikaans', 'code' => 'af'],
        ['country' => 'Albanian', 'code' => 'sq'],
        ['country' => 'Arabic', 'code' => 'ar'],
        ['country' => 'Arabic (EGY)', 'code' => 'ar_EG'],
        ['country' => 'Arabic (UAE)', 'code' => 'ar_AE'],
        ['country' => 'Arabic (LBN)', 'code' => 'ar_LB'],
        ['country' => 'Arabic (MAR)', 'code' => 'ar_MA'],
        ['country' => 'Arabic (QAT)', 'code' => 'ar_QA'],
        ['country' => 'Azerbaijani', 'code' => 'az'],
        ['country' => 'Belarusian', 'code' => 'be_BY'],
        ['country' => 'Bengali', 'code' => 'bn'],
        ['country' => 'Bengali (IND)', 'code' => 'bn_IN'],
        ['country' => 'Bulgarian', 'code' => 'bg'],
        ['country' => 'Catalan', 'code' => 'ca'],
        ['country' => 'Chinese (CHN)', 'code' => 'zh_CN'],
        ['country' => 'Chinese (HKG)', 'code' => 'zh_HK'],
        ['country' => 'Chinese (TAI)', 'code' => 'zh_TW'],
        ['country' => 'Croatian', 'code' => 'hr'],
        ['country' => 'Czech', 'code' => 'cs'],
        ['country' => 'Danish', 'code' => 'da'],
        ['country' => 'Dari', 'code' => 'prs_AF'],
        ['country' => 'Dutch', 'code' => 'nl'],
        ['country' => 'Dutch (BEL)', 'code' => 'nl_BE'],
        ['country' => 'English', 'code' => 'en'],
        ['country' => 'English (UK)', 'code' => 'en_GB'],
        ['country' => 'English (US)', 'code' => 'en_US'],
        ['country' => 'English (UAE)', 'code' => 'en_AE'],
        ['country' => 'English (AUS)', 'code' => 'en_AU'],
        ['country' => 'English (CAN)', 'code' => 'en_CA'],
        ['country' => 'English (GHA)', 'code' => 'en_GH'],
        ['country' => 'English (IRL)', 'code' => 'en_IE'],
        ['country' => 'English (IND)', 'code' => 'en_IN'],
        ['country' => 'English (JAM)', 'code' => 'en_JM'],
        ['country' => 'English (MYS)', 'code' => 'en_MY'],
        ['country' => 'English (NZL)', 'code' => 'en_NZ'],
        ['country' => 'English (QAT)', 'code' => 'en_QA'],
        ['country' => 'English (SGP)', 'code' => 'en_SG'],
        ['country' => 'English (UGA)', 'code' => 'en_UG'],
        ['country' => 'English (ZAF)', 'code' => 'en_ZA'],
        ['country' => 'Estonian', 'code' => 'et'],
        ['country' => 'Filipino', 'code' => 'fil'],
        ['country' => 'Finnish', 'code' => 'fi'],
        ['country' => 'French', 'code' => 'fr'],
        ['country' => 'French (BEL)', 'code' => 'fr_BE'],
        ['country' => 'French (CAN)', 'code' => 'fr_CA'],
        ['country' => 'French (CHE)', 'code' => 'fr_CH'],
        ['country' => 'French (CIV)', 'code' => 'fr_CI'],
        ['country' => 'French (MAR)', 'code' => 'fr_MA'],
        ['country' => 'Georgian', 'code' => 'ka'],
        ['country' => 'German', 'code' => 'de'],
        ['country' => 'German (AUT)', 'code' => 'de_AT'],
        ['country' => 'German (CHE)', 'code' => 'de_CH'],
        ['country' => 'Greek', 'code' => 'el'],
        ['country' => 'Gujarati', 'code' => 'gu'],
        ['country' => 'Hausa', 'code' => 'ha'],
        ['country' => 'Hebrew', 'code' => 'he'],
        ['country' => 'Hindi', 'code' => 'hi'],
        ['country' => 'Hungarian', 'code' => 'hu'],
        ['country' => 'Indonesian', 'code' => 'id'],
        ['country' => 'Irish', 'code' => 'ga'],
        ['country' => 'Italian', 'code' => 'it'],
        ['country' => 'Japanese', 'code' => 'ja'],
        ['country' => 'Kannada', 'code' => 'kn'],
        ['country' => 'Kazakh', 'code' => 'kk'],
        ['country' => 'Kinyarwanda', 'code' => 'rw_RW'],
        ['country' => 'Korean', 'code' => 'ko'],
        ['country' => 'Kyrgyz (Kyrgyzstan)', 'code' => 'ky_KG'],
        ['country' => 'Lao', 'code' => 'lo'],
        ['country' => 'Latvian', 'code' => 'lv'],
        ['country' => 'Lithuanian', 'code' => 'lt'],
        ['country' => 'Macedonian', 'code' => 'mk'],
        ['country' => 'Malay', 'code' => 'ms'],
        ['country' => 'Malayalam', 'code' => 'ml'],
        ['country' => 'Marathi', 'code' => 'mr'],
        ['country' => 'Norwegian', 'code' => 'nb'],
        ['country' => 'Pashto', 'code' => 'ps_AF'],
        ['country' => 'Persian', 'code' => 'fa'],
        ['country' => 'Polish', 'code' => 'pl'],
        ['country' => 'Portuguese (BR)', 'code' => 'pt_BR'],
        ['country' => 'Portuguese (POR)', 'code' => 'pt_PT'],
        ['country' => 'Punjabi', 'code' => 'pa'],
        ['country' => 'Romanian', 'code' => 'ro'],
        ['country' => 'Russian', 'code' => 'ru'],
        ['country' => 'Serbian', 'code' => 'sr'],
        ['country' => 'Sinhala', 'code' => 'si_LK'],
        ['country' => 'Slovak', 'code' => 'sk'],
        ['country' => 'Slovenian', 'code' => 'sl'],
        ['country' => 'Spanish', 'code' => 'es'],
        ['country' => 'Spanish (ARG)', 'code' => 'es_AR'],
        ['country' => 'Spanish (CHL)', 'code' => 'es_CL'],
        ['country' => 'Spanish (COL)', 'code' => 'es_CO'],
        ['country' => 'Spanish (CRI)', 'code' => 'es_CR'],
        ['country' => 'Spanish (DOM)', 'code' => 'es_DO'],
        ['country' => 'Spanish (ECU)', 'code' => 'es_EC'],
        ['country' => 'Spanish (HND)', 'code' => 'es_HN'],
        ['country' => 'Spanish (MEX)', 'code' => 'es_MX'],
        ['country' => 'Spanish (PAN)', 'code' => 'es_PA'],
        ['country' => 'Spanish (PER)', 'code' => 'es_PE'],
        ['country' => 'Spanish (SPA)', 'code' => 'es_ES'],
        ['country' => 'Spanish (URY)', 'code' => 'es_UY'],
        ['country' => 'Swahili', 'code' => 'sw'],
        ['country' => 'Swedish', 'code' => 'sv'],
        ['country' => 'Tamil', 'code' => 'ta'],
        ['country' => 'Telugu', 'code' => 'te'],
        ['country' => 'Thai', 'code' => 'th'],
        ['country' => 'Turkish', 'code' => 'tr'],
        ['country' => 'Ukrainian', 'code' => 'uk'],
        ['country' => 'Urdu', 'code' => 'ur'],
        ['country' => 'Uzbek', 'code' => 'uz'],
        ['country' => 'Vietnamese', 'code' => 'vi'],
        ['country' => 'Zulu', 'code' => 'zu'],
    ];

    
        foreach ($languages as $language) {
            TemplateLanguage::create([
                'country' => $language['country'],
                'code' => $language['code'],
            ]);
        }

    }
}
